#!/bin/bash -p
#
#   If  the shell is started with the effective user (group) id not equal to the real user (group) id, and the -p option is not supplied,
#   no startup files are read, shell functions are not inherited from the environment, the SHELLOPTS variable, if it appears in the environment,
#   is ignored, and the effective user id is set to the real user id.
#   If the -p option is supplied at invocation, the startup behavior is the same, but the effective user id is not reset.
#-----------------------------------------------------------------------------

#  preflight.sh
#  Lili
#
#  Copyright (c) 2020 LogMeIn. All rights reserved.
#
#  Runs as root

LOGFILE=$1
exec 2>&1 # >>$LOGFILE   We do not need this anymore, script runners capture script outputs

BUNDLEPATH=$2
ROOTPATH=$3

echo "preflight(as root): started with path $ROOTPATH and bundlepath $BUNDLEPATH"
echo "current uid=${UID}, gid=$( id | awk -F= '/gid=/ { print $3 }' | awk -F\(  '{ print $1 }' ), euid=${EUID}, egig=$(id -g), user=${USER}"
echo "id=$(id)"

echo "Checking archive"
TEMPFOLDER=/tmp/hamachi-package-check
/usr/bin/ditto -xv "$BUNDLEPATH/Contents/Resources/archive.pax.gz" "$TEMPFOLDER" || exit 1
/bin/rm -rf "$TEMPFOLDER"

echo "Stopping Hamachi apps"
/usr/bin/killall "LogMeIn Hamachi"

echo "Stopping user MenuBars"
for uid in `ps -axc -o "user uid command" | grep -i "loginwindow" | tr -s ' ' | grep -v -e "^root " | cut -f 2 -d ' '`; do
    /bin/launchctl bootout gui/${uid} /Library/LaunchAgents/com.logmein.hamachimb.plist
    /bin/launchctl disable gui/${uid}/com.logmein.hamachimb
done

echo "Stopping Engine"
/bin/launchctl bootout system /Library/LaunchDaemons/com.logmein.hamachi.plist
/bin/launchctl disable system/com.logmein.hamachi

sleep 1

echo "Unloading kext"
/sbin/kextunload -v 6 /Library/Extensions/ham.kext
/sbin/kextunload -v 6 /Library/Extensions/ham.kext

sleep 1

echo "Removing files/folders of older Hamachi versions..."
/bin/rm -rfv "/Applications/LogMeIn Hamachi"
/bin/rm -rfv "/Applications/LogMeIn Hamachi.app"
/bin/rm -rfv "/Applications/LogMeIn Hamachi Uninstaller.app"
/bin/rm -rfv "/Library/Application Support/LogMeIn Hamachi/bin"
/bin/rm -rfv "/Library/Application Support/LogMeIn Hamachi/run"
/bin/rm -rfv "/Library/Application Support/LogMeIn Hamachi/TunTap-Changelog"
/bin/rm -rfv "/Library/Application Support/LogMeIn Hamachi/TunTap-License.rtfd"
/bin/rm -fv  "/Library/Application Support/LogMeIn Hamachi/"*
/bin/rm -rfv "/Library/Extensions/ham.kext"
/bin/rm -rfv "/Library/Extensions/hamns.kext"
/bin/rm -rfv "/System/Library/Extensions/ham.kext"
/bin/rm -rfv "/System/Library/Extensions/hamns.kext"
/bin/rm -fv  "/Library/LaunchDaemons/com.logmein.hamachi.plist"
/bin/rm -fv  "/Library/LaunchAgents/com.logmein.hamachimb.plist"

echo "preflight: finished"

# return 0 in case of success
# return 253 in case of success but signal user logoff required to finalize install
# return 254 in case of success but signal OS restart required to finalize install
# return 255 or a negative value in case of errors

exit 0
