#!/bin/bash -p
#
#   If  the shell is started with the effective user (group) id not equal to the real user (group) id, and the -p option is not supplied,
#   no startup files are read, shell functions are not inherited from the environment, the SHELLOPTS variable, if it appears in the environment,
#   is ignored, and the effective user id is set to the real user id.
#   If the -p option is supplied at invocation, the startup behavior is the same, but the effective user id is not reset.
#-----------------------------------------------------------------------------

#  postflight.sh
#  Lili
#
#  Copyright (c) 2020 LogMeIn. All rights reserved.
#
#  Runs as root

LOGFILE=$1
exec 2>&1 # >>$LOGFILE   We do not need this anymore, script runners capture script outputs

BUNDLEPATH=$2
ROOTPATH=$3
FILELIST=$4     # The format of the file containing file metadata is: path:owner:group:permissions

if [ "x$FILELIST" == "x" ]; then echo "postflight: missing input filename"; exit 1; fi
if [ "x$ROOTPATH" == "x" ]; then echo "postflight: missing root path"; exit 1; fi

echo "postflight(as root): started with file(s) $FILELIST on path $ROOTPATH and bundlepath $BUNDLEPATH"
echo "current uid=${UID}, gid=$( id | awk -F= '/gid=/ { print $3 }' | awk -F\(  '{ print $1 }' ), euid=${EUID}, egig=$(id -g), user=${USER}"
echo "id=$(id)"


[ -d /etc/resolver ] || /bin/mkdir -p -m 755 /etc/resolver

# if doesn't exist, create hamachi user group and add admin users to it
readonly group="hamachi"

/usr/sbin/dseditgroup -q -o read "${group}"
if [ $? -ne 0 ]; then
    echo "Create ${group} group and add administrator users to it"
    
    # note: Adding "admin" group to "hamachi" (as a nested group) doesn't work as Posix file permissions
    #       doesn't work with nested groups. They are based on GUIDs and work with ACLs.
    /usr/sbin/dseditgroup -q -o create -T group "${group}"
    
    for user in `/usr/bin/dscl . read /Groups/admin GroupMembership | cut -d ' ' -f 2-`; do
        if [ "${user}" != "root" ]; then
            echo "Add ${user} user to ${group} group"
            /usr/sbin/dseditgroup -q -o edit -a "${user}" -t user -T group "${group}"
        fi
    done

    /usr/sbin/dseditgroup -q -o read "${group}"
fi

# create link
/bin/ln -sf "/Library/Application Support/LogMeIn Hamachi/bin/hamachid.app/Contents/MacOS/hamachid" /usr/bin/hamachi
/bin/mkdir /usr/local/bin
/bin/ln -sf "/Library/Application Support/LogMeIn Hamachi/bin/hamachid.app/Contents/MacOS/hamachid" /usr/local/bin/hamachi


# need to remove write from group
/bin/chmod -R go-w "/Library/Extensions/ham.kext"
/usr/sbin/chown -R root:wheel "/Library/Extensions/ham.kext"

/bin/chmod 644 "/Library/LaunchDaemons/com.logmein.hamachi.plist"
/bin/chmod 644 "/Library/LaunchAgents/com.logmein.hamachimb.plist"
/usr/sbin/chown root:wheel "/Library/LaunchDaemons/com.logmein.hamachi.plist"
/usr/sbin/chown root:wheel "/Library/LaunchAgents/com.logmein.hamachimb.plist"

/bin/chmod 777 "/Library/Application Support/LogMeIn Hamachi/run"

# remove 'com.apple.quarantine' attribute from applications
xattr -d com.apple.quarantine "/Applications/LogMeIn Hamachi.app"
xattr -d com.apple.quarantine "/Applications/LogMeIn Hamachi Uninstaller.app"
xattr -d com.apple.quarantine "/Library/Application Support/LogMeIn Hamachi/bin/"*

# process deployid
INSTALL_LINK="/tmp/hamachi_deploy_id"
ENGINE_CFG_DIR="/Library/Application Support/LogMeIn Hamachi/config"

/bin/mkdir -p "$ENGINE_CFG_DIR"

/bin/cat  "$INSTALL_LINK" >> "$ENGINE_CFG_DIR/h2-engine.cfg"
/bin/rm "$INSTALL_LINK" "$INSTALL_LINK.bak"

sleep 2

echo Starting Engine...
/bin/launchctl enable system/com.logmein.hamachi
/bin/launchctl bootstrap system /Library/LaunchDaemons/com.logmein.hamachi.plist

sleep 2
echo Engine started

echo Starting MenuBars...
for uid in `ps -axc -o "user uid command" | grep -i "loginwindow" | tr -s ' ' | grep -v -e "^root " | cut -f 2 -d ' '`; do
    /bin/launchctl enable gui/${uid}/com.logmein.hamachimb
    /bin/launchctl bootstrap gui/${uid} /Library/LaunchAgents/com.logmein.hamachimb.plist
done

echo MenuBars started

echo "postflight: finished"

# return 0 in case of success
# return 253 in case of success but signal user logoff required to finalize install
# return 254 in case of success but signal OS restart required to finalize install
# return 255 or a negative value in case of errors

exit  0
